package ru.uss.vstore.localserver;

import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

/**
 * Ответ за запрос подписания данных
 *
 * @author dauren
 * @since 27.02.2018
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SignatureGenResponse")
public class SignatureGenResponse {

    @XmlElement
    @Documentation("Подписанные данные")
    private String signedData;

    @XmlElement
    @Documentation("Подпись")
    private String signature;

    public SignatureGenResponse(){}

    public SignatureGenResponse(String signedData, String signature) {
        this.signedData = signedData;
        this.signature = signature;
    }

    public String getSignedData() {
        return signedData;
    }

    public void setSignedData(String signedData) {
        this.signedData = signedData;
    }

    public String getSignature() {
        return signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }
}
